/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.io.File;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import updater.Digest;
import updater.FileDownloadHelper;
import updater.ServiceStatusWrapper;
import updater.UpdaterView;

public class Updater {
    private static final String UPDATE_URL = "http://www.tommasomadonia.com/wakeup/server/ota/";
    private static final String DIGEST_URL = "http://www.tommasomadonia.com/wakeup/server/ota/digest";
    private static final File tempDir = new File("." + File.separator + "temp" + File.separator);
    private static final String version = "1.0";
    private static final Set<String> exclude = new HashSet<String>(Arrays.asList("commands.bat", "WakeUpService32.exe", "WakeUpService32.ini", "WakeUpService64.exe", "WakeUpService64.ini"));
    private static final Set<String> excludeForever = new HashSet<String>(Arrays.asList("WakeUpServer.exe"));
    private static ServerSocket socket;
    private static FileDownloadHelper downloadHelper;
    private static UpdaterView updaterView;
    private static HashMap<String, File> downloadedFiles;

    public static void main(String[] args) {
        Updater.validateRun();
        Updater.emptyTempDir();
        try {
            Updater.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (updaterView == null) {
                System.exit(0);
            }
            Updater.delegate("\nError while updating, try again.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void run() throws Exception {
        updaterView = new UpdaterView();
        updaterView.setVisible(true);
        Updater.updaterView.textArea.append("WakeUp Updater v1.0:");
        if (ServiceStatusWrapper.isInstalled("WakeUpServer")) {
            Updater.delegate("Detected WakeUp Server service.");
            int state = ServiceStatusWrapper.getState("WakeUpServer");
            if (state != 1) {
                Updater.delegate("Wait until the service is stopped...");
                while (state != 1) {
                    Thread.sleep(1000L);
                    state = ServiceStatusWrapper.getState("WakeUpServer");
                }
            } else {
                Updater.delegate("The service is not running.");
            }
        }
        Digest srcDigest = new Digest("digest");
        srcDigest.make();
        HashMap<Object, Object> localMap = new HashMap();
        try {
            Updater.delegate("Listing local file...");
            localMap = srcDigest.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            Updater.delegate(e.getLocalizedMessage());
            throw e;
        }
        downloadHelper = new FileDownloadHelper(tempDir);
        HashMap<Object, Object> updateMap = new HashMap();
        try {
            Updater.delegate("Retriving file list...");
            File file = File.createTempFile("digest", "");
            downloadHelper.downloadFile(new URL(DIGEST_URL), file);
            file.deleteOnExit();
            Iterator<Object> dstDigest = new Digest(file.getAbsolutePath());
            updateMap = ((Digest)((Object)dstDigest)).parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Updater.delegate(exception.getLocalizedMessage());
            throw exception;
        }
        for (String string : localMap.keySet()) {
            try {
                File file = new File(string);
                if (excludeForever.contains(file.getName())) {
                    updateMap.remove(string);
                    continue;
                }
                if (exclude.contains(file.getName()) && !file.exists()) {
                    updateMap.remove(string);
                    continue;
                }
                if (!((String)localMap.get(string)).equals(updateMap.get(string))) continue;
                updateMap.remove(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Updater.delegate(String.valueOf(updateMap.keySet().size()) + " files need update:");
        for (String string : updateMap.keySet()) {
            void var3_12;
            if (string.startsWith("." + File.separator)) {
                String string2 = string.substring(2);
            }
            Updater.delegate("\u00b7 " + (String)var3_12);
        }
        downloadedFiles = new HashMap();
        boolean bl = true;
        int size = updateMap.keySet().size();
        if (updaterView != null) {
            updaterView.setIndeterminate(false);
            Updater.updaterView.progressBar.setMinimum(0);
            Updater.updaterView.progressBar.setMaximum(size);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (String currentFile : downloadedFiles.keySet()) {
                    try {
                        Files.delete(((File)downloadedFiles.get(currentFile)).toPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        for (String string : updateMap.keySet()) {
            void var3_14;
            if (updaterView != null) {
                Updater.updaterView.progressBar.setString(String.valueOf((int)var3_14) + " file of " + size);
            }
            URL url = new URL(UPDATE_URL + string.substring(string.startsWith("." + File.separator) ? 2 : 0).replace(File.separatorChar, '/'));
            File dest = File.createTempFile((String)updateMap.get(string), "");
            Updater.delegate("Downloading " + url.getFile().substring(url.getFile().lastIndexOf("/") + 1) + "...");
            if (Updater.downloadFile(url, dest, (String)updateMap.get(string))) {
                Updater.delegate(" CRC OK!", false);
                downloadedFiles.put((String)updateMap.get(string), dest);
            } else {
                Updater.delegate(" ERROR!", false);
            }
            if (updaterView != null) {
                Updater.updaterView.progressBar.setValue((int)var3_14);
            }
            ++var3_14;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String currentFile : downloadedFiles.keySet()) {
            try {
                if (!Updater.backupAndReplace(new File((String)Updater.getKeyByValue(updateMap, currentFile)), downloadedFiles.get(currentFile))) continue;
                arrayList.add(currentFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                Updater.delegate(e.getLocalizedMessage());
            }
        }
        Updater.delegate(String.valueOf(arrayList.size()) + " files updated successfully, " + (updateMap.keySet().size() - arrayList.size()) + " errors.");
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean backupAndReplace(File oldFile, File newFile) {
        try {
            if (oldFile != null) {
                Updater.delegate("Copying " + oldFile.getName() + "...");
            }
            Files.copy(newFile.toPath(), oldFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Updater.delegate(" OK!", false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (oldFile != null) {
                Updater.delegate(" ERROR!", false);
            }
            return false;
        }
    }

    private static boolean downloadFile(URL url, File dest, String crc) {
        try {
            downloadHelper.downloadFile(url, dest);
            return crc.equals(Digest.file2md5(dest));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void validateRun() {
        try {
            socket = new ServerSocket(1000);
            socket.getLocalPort();
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    private static void emptyTempDir() {
        if (tempDir.exists() && tempDir.isDirectory()) {
            File[] fileArray = tempDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File currentFile = fileArray[n2];
                currentFile.delete();
                ++n2;
            }
        }
    }

    private static void delegate(String text, boolean newLine) {
        if (updaterView != null) {
            Updater.updaterView.textArea.append(String.valueOf(newLine ? "\n" : "") + text);
        }
    }

    private static void delegate(String text) {
        Updater.delegate(text, true);
    }
}

