/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;

public class UpdaterView
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String propertyFile = "options.prop";
    public JTextArea textArea;
    public JProgressBar progressBar;
    public JScrollPane scrollPane;

    public UpdaterView() {
        super("WakeUp Updater");
        this.setDefaultCloseOperation(3);
        this.setSize(500, 300);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setup();
    }

    public void setup() {
        JPanel pane = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pane.setLayout(gbl);
        int row = 0;
        this.setColumnMinWidth(gbl, 0, 10);
        this.setRowMinHeight(gbl, row, 10);
        ++row;
        this.progressBar = new JProgressBar();
        this.progressBar.setEnabled(true);
        this.setIndeterminate(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = row++;
        gbc.anchor = 21;
        gbc.fill = 2;
        pane.add((Component)this.progressBar, gbc);
        this.setRowMinHeight(gbl, row, 10);
        ++row;
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.scrollPane = new JScrollPane(this.textArea);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = row++;
        gbc.anchor = 21;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        pane.add((Component)this.scrollPane, gbc);
        this.setColumnMinWidth(gbl, 2, 10);
        this.setRowMinHeight(gbl, row, 10);
        this.getContentPane().add(pane);
        this.setLocationByPlatform(true);
        UpdaterView.restoreOptions(this);
    }

    private void setRowMinHeight(GridBagLayout gbl, int r, int h) {
        int[] hs = gbl.rowHeights;
        if (hs == null) {
            hs = new int[r + 1];
        } else if (hs.length < r + 1) {
            hs = new int[r + 1];
            System.arraycopy(gbl.rowHeights, 0, hs, 0, gbl.rowHeights.length);
        }
        hs[r] = h;
        gbl.rowHeights = hs;
    }

    private void setColumnMinWidth(GridBagLayout gbl, int c, int w) {
        int[] ws = gbl.columnWidths;
        if (ws == null) {
            ws = new int[c + 1];
        } else if (ws.length < c + 1) {
            ws = new int[c + 1];
            System.arraycopy(gbl.columnWidths, 0, ws, 0, gbl.columnWidths.length);
        }
        ws[c] = w;
        gbl.columnWidths = ws;
    }

    public static Preferences getPrefs() {
        return Preferences.userRoot().node("wakeupserver");
    }

    public static void restoreOptions(JFrame f) {
        Preferences prefs = UpdaterView.getPrefs();
        int x = prefs.getInt("x", f.getX());
        int y = prefs.getInt("y", f.getY());
        Rectangle r = new Rectangle(x, y, f.getWidth(), f.getHeight());
        f.setBounds(r);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
        this.progressBar.setStringPainted(!indeterminate);
    }
}

