/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import org.apache.sshd.SshServer;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.server.auth.UserAuthNone;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import wakeupserver.Main;
import wakeupserver.SshServerPasswordAuthenticator;
import wakeupserver.SystemTrayFrame;
import wakeupserver.WakeupCommandFactory;

public class ServerManager
extends ReceiverAdapter {
    private SshServer server;
    private boolean running;
    private boolean requestShutdown;
    private SystemTrayFrame delegate;
    private JChannel channel;

    public ServerManager(boolean isService) {
        int port = SystemTrayFrame.getPort(isService);
        this.server = SshServer.setUpDefaultServer();
        this.server.setPort(port);
        this.server.setKeyPairProvider(new SimpleGeneratorHostKeyProvider(String.valueOf(System.getProperty("java.io.tmpdir")) + "hostkey.ser"));
        this.server.setCommandFactory(new WakeupCommandFactory());
        this.server.setPasswordAuthenticator(new SshServerPasswordAuthenticator());
        this.running = false;
        this.requestShutdown = false;
    }

    public void setDelegate(SystemTrayFrame delegate) {
        this.delegate = delegate;
        if (this.isRunning()) {
            delegate.setServerState("Server up on port " + this.getPort());
        } else {
            delegate.setServerState("Server down");
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        try {
            this.server.start();
            if (Main.userAuthNoneEnabled()) {
                if (this.server.getUserAuthFactories() != null && NamedFactory.Utils.get(this.server.getUserAuthFactories(), "none") == null) {
                    this.server.getUserAuthFactories().add(new UserAuthNone.Factory());
                }
                if (this.server.getUserAuthFactories() != null && NamedFactory.Utils.get(this.server.getUserAuthFactories(), "password") == null) {
                    this.server.getUserAuthFactories().add(new UserAuthPassword.Factory());
                }
            }
            this.running = true;
            if (this.delegate != null) {
                this.delegate.setServerState("Server up on port " + this.getPort());
            }
            if (this.channel != null) {
                this.channel.send(new Message(null, this.channel.getAddress(), "Server up on port " + this.getPort()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean immediately) {
        try {
            this.server.stop(immediately);
            this.running = false;
            if (this.delegate != null) {
                this.delegate.setServerState("Server down");
            }
            if (this.channel != null) {
                this.channel.send(new Message(null, this.channel.getAddress(), "Server is down"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void restart() {
        this.stop(true);
        this.start();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void changePort(int port) {
        try {
            this.stop(true);
            this.server.setPort(port);
            this.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void receive(Message msg) {
        try {
            String message = "" + msg.getObject();
            if (message.startsWith("Change port:")) {
                this.changePort(Integer.parseInt(message.substring(12)));
            } else if (message.startsWith("Shutdown server")) {
                this.requestShutdown = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        try {
            if (this.channel != null) {
                this.channel.send(new Message(null, this.channel.getAddress(), this.isRunning() ? "Server up on port " + this.getPort() : "Server is down"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startChannel() {
        try {
            this.channel = new JChannel();
            this.channel.setReceiver(this);
            this.channel.connect("WakeUpCluster");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeChannel() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public boolean requestShutdown() {
        return this.requestShutdown;
    }
}

