/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import wakeupserver.Main;
import wakeupserver.PowrProf;
import wakeupserver.ServerManager;
import wakeupserver.ServiceStatusWrapper;
import wakeupserver.SshServerPasswordAuthenticator;
import wakeupserver.VBSUtils;
import wakeupserver.Version;

public class SystemTrayFrame
extends JFrame
implements WindowListener,
ActionListener,
Receiver {
    private static final long serialVersionUID = 1L;
    private static final Version version = new Version(1, 0);
    private static final String websiteURL = "http://www.tommasomadonia.com";
    private static final String versionURL = "http://www.tommasomadonia.com/wakeup/server/version.php";
    private static final String email = "tommaso.madonia@gmail.com";
    private static final String serviceName = "WakeUpServer";
    public static final String fileName = "options.prop";
    private ServerManager serverManager;
    private boolean isService;
    private TrayIcon trayIcon;
    private JPopupMenu popupMenu;
    private JLabel titleLabel;
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private JLabel portLabel;
    private JLabel statusLabel;
    private JTextField usernameField;
    private JTextField portField;
    private JPasswordField passwordField;
    private JCheckBox startupBox;
    private JCheckBox updateBox;
    private JCheckBox hibernateBox;
    private JButton websiteButton;
    private JButton emailButton;
    private JButton serviceButton;
    private JButton saveButton;
    private JChannel channel;
    private Address lastServerAddress;
    private CheckService checkService;
    private boolean passwordChanged;

    public SystemTrayFrame(ServerManager serverManager, boolean isService) {
        super("WakeUp Server configuration");
        this.serverManager = serverManager;
        this.isService = isService;
        this.passwordChanged = false;
        this.setFocusable(true);
        this.setSize(300, 325);
        this.setMinimumSize(this.getSize());
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(Toolkit.getDefaultToolkit().getImage("Icon.png"));
        imageList.add(Toolkit.getDefaultToolkit().getImage("Icon-72.png"));
        imageList.add(Toolkit.getDefaultToolkit().getImage("Icon-Small.png"));
        imageList.add(Toolkit.getDefaultToolkit().getImage("Icon-Small-50.png"));
        this.setIconImages(imageList);
        if (this.getAutoUpdate()) {
            new CheckUpdate().start();
        }
    }

    public static void storeOptions(JFrame f) throws Exception {
        Preferences prefs = SystemTrayFrame.getPrefs();
        f.setExtendedState(0);
        Rectangle r = f.getBounds();
        prefs.putInt("x", (int)r.getX());
        prefs.putInt("y", (int)r.getY());
        prefs.putInt("w", (int)r.getWidth());
        prefs.putInt("h", (int)r.getHeight());
    }

    public static Preferences getPrefs() {
        return SystemTrayFrame.getPrefs(false);
    }

    public static Preferences getPrefs(boolean isService) {
        if (isService) {
            return Preferences.systemRoot().node("wakeupserver");
        }
        return Preferences.userRoot().node("wakeupserver");
    }

    public void restoreOptions(JFrame f) {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        int x = prefs.getInt("x", f.getX());
        int y = prefs.getInt("y", f.getY());
        int w = prefs.getInt("w", f.getWidth());
        int h = prefs.getInt("h", f.getHeight());
        Rectangle r = new Rectangle(x, y, w, h);
        f.setBounds(r);
    }

    public void storePassword(JPasswordField passwordField) throws Exception {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        String password = String.valueOf(passwordField.getPassword());
        prefs.put("password", SshServerPasswordAuthenticator.hashPassword(password));
        prefs.putInt("l", password.length());
        password = null;
    }

    public void storeUsername(JTextField usernameField) throws Exception {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        prefs.put("username", usernameField.getText());
    }

    public int getPort() {
        return SystemTrayFrame.getPort(this.isService());
    }

    public static int getPort(boolean isService) {
        Preferences prefs = SystemTrayFrame.getPrefs(isService);
        return prefs.getInt("port", 22);
    }

    public void storePort(JTextField portField) throws Exception {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        try {
            prefs.putInt("port", Integer.parseInt(portField.getText()));
        }
        catch (Exception e) {
            e.printStackTrace();
            prefs.remove("port");
        }
    }

    public boolean getAutoUpdate() {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        return prefs.getBoolean("autoupdate", true);
    }

    public void storeAutoUpdate(JCheckBox checkBox) throws Exception {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        prefs.putBoolean("autoupdate", checkBox.isSelected());
    }

    public boolean getHibernate() {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        return prefs.getBoolean("hibernate", false);
    }

    public void storeHibernate(JCheckBox checkBox) throws Exception {
        Preferences prefs = SystemTrayFrame.getPrefs(this.isService());
        prefs.putBoolean("hibernate", checkBox.isSelected());
    }

    public boolean isService() {
        return this.isService;
    }

    public void setup(boolean minimized) {
        if (!this.isService()) {
            this.setupPopupMenu();
            this.setupSystemTrayIcon();
        }
        this.setupFrame();
        this.setVisible(!minimized);
        if (this.isService()) {
            try {
                this.channel = new JChannel();
                this.channel.setReceiver(this);
                this.channel.connect("WakeUpCluster");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    private void setupFrame() {
        JPanel pane = new JPanel();
        pane.setFocusable(true);
        GridBagLayout gbl = new GridBagLayout();
        pane.setLayout(gbl);
        int serviceState = this.isService() ? ServiceStatusWrapper.getState(serviceName) : -1;
        int y = 0;
        int gridC = 8;
        this.setColumnMinWidth(gbl, 0, 10);
        JPanel titlePane = new JPanel();
        titlePane.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel("Server");
        this.titleLabel.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 5);
        titlePane.add((Component)this.titleLabel, gbc);
        JSeparator titleSeparator = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.gridwidth = gridC - 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        titlePane.add((Component)titleSeparator, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 2;
        gbc.fill = 2;
        pane.add((Component)titlePane, gbc);
        this.usernameLabel = new JLabel("Username:");
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.anchor = 512;
        gbc.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)this.usernameLabel, gbc);
        this.usernameField = new JTextField();
        this.usernameField.setText(SshServerPasswordAuthenticator.getUsername());
        this.usernameField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SystemTrayFrame.this.usernameField.getText().equals("")) {
                    SystemTrayFrame.this.usernameField.setText(SshServerPasswordAuthenticator.getUsername());
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 3;
        gbc.weightx = 1.0;
        gbc.anchor = 256;
        gbc.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)this.usernameField, gbc);
        this.passwordLabel = new JLabel("Password:");
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.anchor = 512;
        gbc.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)this.passwordLabel, gbc);
        this.passwordField = new JPasswordField();
        this.passwordField.setText(SshServerPasswordAuthenticator.getPasswordField());
        this.passwordField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SystemTrayFrame.this.passwordField.setText("");
                SystemTrayFrame.this.passwordChanged = true;
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SystemTrayFrame.this.passwordField.getPassword().length == 0) {
                    SystemTrayFrame.this.passwordChanged = false;
                    SystemTrayFrame.this.passwordField.setText(SshServerPasswordAuthenticator.getPasswordField());
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 3;
        gbc.weightx = 1.0;
        gbc.anchor = 256;
        gbc.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)this.passwordField, gbc);
        this.portLabel = new JLabel("Port:");
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.anchor = 512;
        gbc.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)this.portLabel, gbc);
        this.portField = new JTextField();
        this.portField.setText("" + this.getPort());
        this.portField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (SystemTrayFrame.this.portField.getText().equals("")) {
                    SystemTrayFrame.this.portField.setText("" + SystemTrayFrame.this.getPort());
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.gridwidth = gridC - 5;
        gbc.weightx = 1.0;
        gbc.anchor = 256;
        gbc.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)this.portField, gbc);
        this.saveButton = new JButton("Save");
        this.saveButton.setFocusPainted(false);
        this.saveButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = gridC - 3;
        gbc.gridy = y++;
        gbc.anchor = 768;
        gbc.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)this.saveButton, gbc);
        this.setRowMinHeight(gbl, y, 10);
        ++y;
        titlePane = new JPanel();
        titlePane.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel("Settings");
        this.titleLabel.setFont(new Font("Tahoma", 1, 11));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 5);
        titlePane.add((Component)this.titleLabel, gbc);
        titleSeparator = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.gridwidth = gridC - 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        titlePane.add((Component)titleSeparator, gbc);
        gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 2;
        gbc.fill = 2;
        pane.add((Component)titlePane, gbc);
        boolean startup = false;
        if (this.isService()) {
            startup = ServiceStatusWrapper.isAuto(serviceName);
        } else {
            try {
                File file = new File(String.valueOf(VBSUtils.getSpecialFolder(VBSUtils.SF_STARTUP)) + "\\WakeUpServer.bat");
                startup = file.exists();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.startupBox = new JCheckBox("Launch on Windows startup");
        this.startupBox.setFocusPainted(false);
        this.startupBox.setEnabled(!this.isService() || serviceState != -1060);
        this.startupBox.setSelected(startup);
        this.startupBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SystemTrayFrame.this.isService()) {
                    SystemTrayFrame.this.execCommand(SystemTrayFrame.this.startupBox.isSelected() ? "auto" : "demand");
                } else {
                    try {
                        File file = new File(String.valueOf(VBSUtils.getSpecialFolder(VBSUtils.SF_STARTUP)) + "\\WakeUpServer.bat");
                        if (SystemTrayFrame.this.startupBox.isSelected()) {
                            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                            bw.write("cd /D \"" + System.getProperty("user.dir") + "\"");
                            bw.newLine();
                            bw.write("start WakeUpServer.exe minimized");
                            bw.newLine();
                            bw.write("exit");
                            bw.close();
                        } else if (file.exists()) {
                            file.delete();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.gridwidth = gridC - 3;
        gbc.anchor = 512;
        pane.add((Component)this.startupBox, gbc);
        this.serviceButton = new JButton("");
        this.serviceButton.setFocusPainted(false);
        this.serviceButton.addActionListener(this);
        if (this.isService()) {
            if (serviceState == -1060) {
                this.serviceButton.setText("Install");
            } else if (serviceState == 1 || serviceState == 3) {
                this.serviceButton.setText("Start");
            } else {
                this.serviceButton.setText("Stop");
            }
        } else {
            this.serviceButton.setText(this.serverManager.isRunning() ? "Stop" : "Start");
        }
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = gridC - 3;
        gbc.gridy = y++;
        gbc.gridheight = 1;
        gbc.anchor = 256;
        gbc.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)this.serviceButton, gbc);
        this.updateBox = new JCheckBox("Automatically checks for updates");
        this.updateBox.setFocusPainted(false);
        this.updateBox.setSelected(this.getAutoUpdate());
        this.updateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SystemTrayFrame.this.storeAutoUpdate(SystemTrayFrame.this.updateBox);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 3;
        gbc.anchor = 512;
        pane.add((Component)this.updateBox, gbc);
        this.hibernateBox = new JCheckBox("Hibernate instead of sleep");
        this.hibernateBox.setFocusPainted(false);
        this.hibernateBox.setEnabled(PowrProf.INSTANCE.IsPwrHibernateAllowed());
        this.hibernateBox.setSelected(this.getHibernate() && this.hibernateBox.isEnabled());
        this.hibernateBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    SystemTrayFrame.this.storeHibernate(SystemTrayFrame.this.hibernateBox);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 3;
        gbc.anchor = 512;
        pane.add((Component)this.hibernateBox, gbc);
        this.setRowMinHeight(gbl, y, 10);
        ++y;
        titlePane = new JPanel();
        titlePane.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel("Info");
        this.titleLabel.setFont(new Font("Tahoma", 1, 11));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 5);
        titlePane.add((Component)this.titleLabel, gbc);
        titleSeparator = new JSeparator();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.gridwidth = gridC - 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        titlePane.add((Component)titleSeparator, gbc);
        gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.gridwidth = gridC - 2;
        gbc.fill = 2;
        pane.add((Component)titlePane, gbc);
        JLabel iconLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage("Icon-Small-50.png")));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        gbc.gridheight = 3;
        gbc.anchor = 512;
        gbc.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)iconLabel, gbc);
        JLabel serverLabel = new JLabel("WakeUp Server");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.anchor = 256;
        gbc.insets = new Insets(5, 5, 0, 0);
        pane.add((Component)serverLabel, gbc);
        this.websiteButton = new JButton("Website");
        this.websiteButton.setFocusPainted(false);
        this.websiteButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = gridC - 3;
        gbc.gridy = y++;
        gbc.gridheight = 2;
        gbc.anchor = 256;
        gbc.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)this.websiteButton, gbc);
        JLabel versionLabel = new JLabel("Version: " + version);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.anchor = 256;
        gbc.insets = new Insets(3, 5, 0, 0);
        pane.add((Component)versionLabel, gbc);
        this.statusLabel = new JLabel(this.isService() && serviceState == -1060 ? "Server not installed" : "Server not found");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.anchor = 256;
        gbc.insets = new Insets(3, 5, 0, 0);
        pane.add((Component)this.statusLabel, gbc);
        this.emailButton = new JButton("  Email   ");
        this.emailButton.setFocusPainted(false);
        this.emailButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridx = gridC - 3;
        gbc.gridy = y++;
        gbc.gridheight = 1;
        gbc.anchor = 256;
        gbc.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)this.emailButton, gbc);
        JLabel copyLabel = new JLabel("\u00a9 2013 Tommaso Madonia - tommaso.madonia@gmail.com", 0);
        copyLabel.setFont(new Font(copyLabel.getFont().getName(), copyLabel.getFont().getStyle(), 9));
        copyLabel.setForeground(Color.gray);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.gridwidth = gridC - 2;
        gbc.anchor = 512;
        gbc.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)copyLabel, gbc);
        this.setColumnMinWidth(gbl, gridC - 1, 10);
        this.getContentPane().add(pane);
        this.getContentPane().setFocusable(true);
        this.setDefaultCloseOperation(this.isService() ? 3 : 0);
        this.addWindowListener(this);
        this.setLocationByPlatform(true);
        this.restoreOptions(this);
    }

    public void setColumnMinWidth(GridBagLayout gbl, int c, int w) {
        int[] ws = gbl.columnWidths;
        if (ws == null) {
            ws = new int[c + 1];
        } else if (ws.length < c + 1) {
            ws = new int[c + 1];
            System.arraycopy(gbl.columnWidths, 0, ws, 0, gbl.columnWidths.length);
        }
        ws[c] = w;
        gbl.columnWidths = ws;
    }

    public void setRowMinHeight(GridBagLayout gbl, int r, int h) {
        int[] hs = gbl.rowHeights;
        if (hs == null) {
            hs = new int[r + 1];
        } else if (hs.length < r + 1) {
            hs = new int[r + 1];
            System.arraycopy(gbl.rowHeights, 0, hs, 0, gbl.rowHeights.length);
        }
        hs[r] = h;
        gbl.rowHeights = hs;
    }

    private void setupPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem open = new JMenuItem("Open");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemTrayFrame.this.setVisible(true);
            }
        });
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SystemTrayFrame.this.serverManager != null) {
                    SystemTrayFrame.this.serverManager.stop(true);
                }
                SystemTrayFrame.this.setVisible(false);
                SystemTray.getSystemTray().remove(SystemTrayFrame.this.trayIcon);
                System.exit(0);
            }
        });
        this.popupMenu.add(open);
        this.popupMenu.addSeparator();
        this.popupMenu.add(exit);
    }

    private void setupSystemTrayIcon() {
        try {
            if (SystemTray.isSupported()) {
                Image image = Toolkit.getDefaultToolkit().getImage("Icon-Small.png");
                this.trayIcon = new TrayIcon(image, "WakeUp server");
                this.trayIcon.setImageAutoSize(true);
                this.trayIcon.addMouseListener(new SystemTrayMouseListener());
                SystemTray.getSystemTray().add(this.trayIcon);
            }
        }
        catch (AWTException ex) {
            ex.printStackTrace();
        }
    }

    public void setServerState(String state) {
        this.statusLabel.setText(state);
        this.serviceButton.setEnabled(true);
        this.serviceButton.setText(this.serverManager.isRunning() ? "Stop" : "Start");
    }

    private void execCommand(String command) {
        try {
            File dir = new File(".");
            Runtime.getRuntime().exec(new String[]{dir.getCanonicalPath() + File.separator + "commands.bat", command});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        try {
            SystemTrayFrame.storeOptions(this);
            this.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
        this.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveButton) {
            if (this.passwordChanged) {
                this.passwordChanged = false;
                try {
                    this.storePassword(this.passwordField);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.storeUsername(this.usernameField);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                int port = Integer.parseInt(this.portField.getText());
                if (port != this.getPort()) {
                    if (this.serverManager != null) {
                        this.serverManager.changePort(port);
                    } else if (this.channel != null) {
                        try {
                            this.channel.send(new Message(this.lastServerAddress, this.channel.getAddress(), "Change port:" + port));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                this.storePort(this.portField);
                SystemTrayFrame.getPrefs().sync();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (e.getSource() == this.serviceButton) {
            if (this.serviceButton.getText().equals("Install")) {
                this.execCommand("register");
                if (this.checkService == null) {
                    this.checkService = new CheckService();
                }
                if (!this.checkService.isAlive()) {
                    this.checkService.start();
                }
            } else if (this.serviceButton.getText().equals("Start")) {
                this.serviceButton.setEnabled(false);
                this.serviceButton.setText("Starting");
                if (this.serverManager != null) {
                    this.serverManager.start();
                } else {
                    ServiceStatusWrapper.startService(serviceName);
                }
            } else if (this.serviceButton.getText().equals("Stop")) {
                this.serviceButton.setEnabled(false);
                this.serviceButton.setText("Stopping");
                if (this.serverManager != null) {
                    this.serverManager.stop();
                } else if (this.channel != null) {
                    try {
                        this.channel.send(new Message(this.lastServerAddress, this.channel.getAddress(), "Shutdown server"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        ServiceStatusWrapper.stopService(serviceName);
                    }
                } else {
                    ServiceStatusWrapper.stopService(serviceName);
                }
            }
        } else if (e.getSource() == this.websiteButton) {
            try {
                Desktop.getDesktop().browse(URI.create(websiteURL));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (e.getSource() == this.emailButton) {
            try {
                String message = "mailto:tommaso.madonia@gmail.com?subject=WakeUp%20Server%20v" + version;
                Desktop.getDesktop().browse(URI.create(message));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void receive(Message msg) {
        try {
            String message = "" + msg.getObject();
            if (message.startsWith("Server")) {
                this.lastServerAddress = msg.getSrc();
                this.statusLabel.setText(message);
                this.serviceButton.setEnabled(true);
                if (message.indexOf("down") != -1) {
                    this.serviceButton.setText("Start");
                } else {
                    this.serviceButton.setText("Stop");
                }
            } else if (message.startsWith("Close client")) {
                if (this.serverManager != null) {
                    this.serverManager.stop(true);
                }
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void getState(OutputStream output) throws Exception {
    }

    @Override
    public void setState(InputStream input) throws Exception {
    }

    @Override
    public void viewAccepted(View view) {
    }

    @Override
    public void suspect(Address mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    class CheckService
    extends Thread {
        CheckService() {
        }

        @Override
        public void run() {
            int finalState = -1060;
            int currentState = -1;
            try {
                try {
                    do {
                        currentState = ServiceStatusWrapper.getState(SystemTrayFrame.serviceName);
                        CheckService.sleep(1000L);
                    } while (currentState == finalState || currentState < 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (currentState == -1060) {
                        SystemTrayFrame.this.serviceButton.setText("Install");
                        SystemTrayFrame.this.startupBox.setEnabled(false);
                    } else if (currentState == 4) {
                        SystemTrayFrame.this.serviceButton.setText("Stop");
                        SystemTrayFrame.this.startupBox.setEnabled(true);
                        if (SystemTrayFrame.this.statusLabel.getText().equals("Server not installed")) {
                            SystemTrayFrame.this.statusLabel.setText("Server is running");
                        }
                    } else if (currentState == 1) {
                        SystemTrayFrame.this.serviceButton.setText("Start");
                        SystemTrayFrame.this.startupBox.setEnabled(true);
                        if (SystemTrayFrame.this.statusLabel.getText().equals("Server not installed")) {
                            SystemTrayFrame.this.statusLabel.setText("Server not found");
                        }
                    }
                    SystemTrayFrame.this.serviceButton.setEnabled(true);
                }
            }
            finally {
                if (currentState == -1060) {
                    SystemTrayFrame.this.serviceButton.setText("Install");
                    SystemTrayFrame.this.startupBox.setEnabled(false);
                } else if (currentState == 4) {
                    SystemTrayFrame.this.serviceButton.setText("Stop");
                    SystemTrayFrame.this.startupBox.setEnabled(true);
                    if (SystemTrayFrame.this.statusLabel.getText().equals("Server not installed")) {
                        SystemTrayFrame.this.statusLabel.setText("Server is running");
                    }
                } else if (currentState == 1) {
                    SystemTrayFrame.this.serviceButton.setText("Start");
                    SystemTrayFrame.this.startupBox.setEnabled(true);
                    if (SystemTrayFrame.this.statusLabel.getText().equals("Server not installed")) {
                        SystemTrayFrame.this.statusLabel.setText("Server not found");
                    }
                }
                SystemTrayFrame.this.serviceButton.setEnabled(true);
            }
        }
    }

    class CheckUpdate
    extends Thread {
        CheckUpdate() {
        }

        @Override
        public void run() {
            try {
                URL url = new URL(SystemTrayFrame.versionURL);
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                String str = in.readLine();
                Version lastVersion = new Version(str);
                if (!version.isUpToDate(lastVersion)) {
                    Object[] options = new String[]{"Download", "Remind me later"};
                    int n = JOptionPane.showOptionDialog(null, "WakeUp Server v" + lastVersion + " is available! Do you want to download it now?", "WakeUp Server Update", 1, 3, null, options, options[0]);
                    if (n == 0) {
                        try {
                            Main.unvalidateRun();
                            Runtime.getRuntime().exec("WakeUpUpdater.exe");
                            System.exit(0);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            if (SystemTrayFrame.this.channel != null) {
                SystemTrayFrame.this.channel.close();
            }
        }
    }

    private class SystemTrayMouseListener
    extends MouseAdapter {
        private SystemTrayMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                SystemTrayFrame.this.setVisible(SystemTrayFrame.this.isVisible());
            } else if (SwingUtilities.isRightMouseButton(e) && SystemTrayFrame.this.popupMenu != null) {
                SystemTrayFrame.this.popupMenu.setLocation(e.getX(), e.getY());
                SystemTrayFrame.this.popupMenu.setInvoker(SystemTrayFrame.this.popupMenu);
                SystemTrayFrame.this.popupMenu.setVisible(true);
            }
        }
    }
}

