/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

public class Version {
    private int major;
    private int minor;
    private int subminor;

    public Version(int major) {
        this(major, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int subminor) {
        this.major = major;
        this.minor = minor;
        this.subminor = subminor;
    }

    public Version(String version) {
        this(0);
        try {
            String[] split = version.split("\\.");
            if (split.length > 0) {
                this.major = Integer.parseInt(split[0]);
            }
            if (split.length > 1) {
                this.minor = Integer.parseInt(split[1]);
            }
            if (split.length > 2) {
                this.subminor = Integer.parseInt(split[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getSubminor() {
        return this.subminor;
    }

    public boolean isUpToDate(Version lastVersion) {
        return this.compareVersion(lastVersion) != -1;
    }

    private int compareVersion(Version lastVersion) {
        if (this.equals(lastVersion)) {
            return 0;
        }
        if (this.major < lastVersion.major) {
            return -1;
        }
        if (this.minor < lastVersion.minor) {
            return -1;
        }
        if (this.subminor < lastVersion.subminor) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.subminor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.subminor == other.subminor;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + (this.subminor != 0 ? "." + this.subminor : "");
    }
}

