/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import java.util.ArrayList;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wakeupserver.WakeupCommand;

public class WakeupCommandFactory
extends ScpCommandFactory {
    protected static final Logger log = LoggerFactory.getLogger(WakeupCommandFactory.class);
    private CommandFactory delegate;

    public WakeupCommandFactory() {
    }

    public WakeupCommandFactory(CommandFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public Command createCommand(String command) {
        try {
            log.info("Creating command {}", (Object)command);
            return new WakeupCommand(this.splitCommandString(command));
        }
        catch (IllegalArgumentException iae) {
            log.warn("Fail to create command {}", (Object)command);
            if (this.delegate != null) {
                return this.delegate.createCommand(command);
            }
            throw iae;
        }
    }

    private String[] splitCommandString(String command) {
        if (!command.trim().startsWith("osascript")) {
            throw new IllegalArgumentException("Unknown command, does not begin with 'osascript'");
        }
        String[] args = command.split(" ");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(args[0]);
        int i = 1;
        while (i < args.length) {
            if (!args[i].trim().startsWith("-")) {
                parts.add(this.concatenateWithSpace(args, i));
                break;
            }
            parts.add(args[i]);
            ++i;
        }
        return parts.toArray(new String[parts.size()]);
    }

    private String concatenateWithSpace(String[] args, int from) {
        StringBuilder sb = new StringBuilder();
        int i = from;
        while (i < args.length) {
            sb.append(String.valueOf(args[i]) + " ");
            ++i;
        }
        return sb.toString().trim();
    }
}

